package com.izenpe.zain.cliente.cades;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class ActualizacionFirmaCades_ES_T_Attached_A {
	// Nombre del fichero cuya firma va a ser actualizada.
	private static final String fileName = "HelloWorld.txt_Attached.p7s";

	public static void main(String[] args) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);

			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT,
					SmartVerifyRequest.Service.DR);

			// Se establece el perfil No Repudio en la peticin de Actualizacin
			// de firma.
			smartVerifyReq.setProfile(Constants.Profile.NONREP);
			
						/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartVerifyReq.setLanguage("es");

			/*
			 * Se solicita en la peticin de Actualizacin que se aadan a la
			 * respuesta los valores de los certificados.
			 */
			smartVerifyReq.setAddCertificateValues(Constants.AddValues.SIMPLE);

			/*
			 * Se solicita en la peticin de Actualizacin que se aadan a la
			 * respuesta la informacin de revocacin de los certificados.
			 */
			smartVerifyReq.setAddRevocationValues(Constants.AddValues.SIMPLE);

			/*
			 * Se solicita en la peticin de Actualizacin que se aadan los
			 * valores del Sello de Tiempo.
			 */
			smartVerifyReq.setAddTimeStampValues(Constants.AddValues.SIMPLE);

			/*
			 * True para que la respuesta incluya el formato de la firma (e.g.
			 * BES, ES-T). La invocacin de mtodo es indispensable para
			 * consultar el formato de la respuesta con getSignatureForm.
			 */
			smartVerifyReq.setAddSignatureForm(true);

			/*
			 * Con el valor Constants.SignatureFormat.ES_A, la respuesta
			 * aadira informacin sobre la validez del certificado.
			 */
			smartVerifyReq.setReturnUpdatedSignature(Constants.SignatureFormat.ES_A);

			// Datos a verificar.
			smartVerifyReq.setSignatureBase64(Base64.encode(ZainUtil.readBinaryFile("data/output/" + fileName)));

			// Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();

			// Se comprueba la validez de la respuesta de Actualizacin de firma
			// PKCS#7.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor()))
					&& Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				String signBase64 = smartVerifyResp.getSignatureBase64();
				byte[] data = Base64.decode(signBase64);
				String destFilename = "data/output/" + "HelloWorld-ESA_Attached.txt.p7s";
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("La firma ha sido actualizada con xito.");
			} else {
				System.out.println("La actualizacin de la firma contiene errores: "
						+ smartVerifyResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}